function analyzeGoNoGoResults5(rootDir)
%This Function will create and Excel output tables
% This code uses parts of the v3 script written by Elan.
%Created by Lukasz Piszczek
%Last Update: 29/07/2015 

dirListing = dir(rootDir); 
TrialByTrialxlsTable = table;
SummaryxlsTable= table;
SummaryxlsTableDependency= table;

for i = 1:length(dirListing)
    if(strcmp(dirListing(i).name,'.') || strcmp(dirListing(i).name,'..') || dirListing(i).isdir) 
        continue;
    else 
        isResult = regexp(dirListing(i).name, '.*\.mat$');
        if ( ~isempty(isResult) )
            resultFile = dirListing(i).name();
            display(resultFile, 'Running File') % display the current file that is iterated
            [SummaryTableDependency, TrialByTrialOutput, SummaryTable] = VariableTrialsScriptOneExpResults([rootDir '\' resultFile]);
            TrialByTrialxlsTable = [TrialByTrialxlsTable; TrialByTrialOutput]; 
            SummaryxlsTable= [SummaryxlsTable; SummaryTable];
            SummaryxlsTableDependency = [SummaryxlsTableDependency; SummaryTableDependency];
        end
    end  
end

% Delete the xls file if exists
if exist([rootDir '\' 'TrialByTrialTable.xls'])==2
   delete([rootDir '\' 'TrialByTrialTable.xls']);
end  

% Write the Trial by trial table as xls file
writetable(TrialByTrialxlsTable ,[rootDir '\' 'TrialByTrialTable.xls']);        

% Delete the xls file if exists            
if exist([rootDir '\' 'SummaryTable.xls'])==2
   delete([rootDir '\' 'SummaryTable.xls']);
end   
% Write the Summary table as xls file
writetable(SummaryxlsTable ,[rootDir '\' 'SummaryTable.xls']);

% Delete the xls file if exists            
if exist([rootDir '\' 'SummaryxlsTableDependency.xls'])==2
   delete([rootDir '\' 'SummaryxlsTableDependency.xls']);
end   
% Write the Summary table as xls file
writetable(SummaryxlsTableDependency ,[rootDir '\' 'SummaryxlsTableDependency.xls']);

end
